"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchAddU2f = dispatchAddU2f;
const u2fkey_1 = require("../../../../database/u2fkey");
const limit_1 = require("../exception/limit");
async function dispatchAddU2f({ action, cache, parentUserId }) {
    const counter = await cache.database.u2fKey.count({
        where: {
            familyId: cache.familyId
        },
        transaction: cache.transaction
    });
    if (counter >= 16)
        throw new limit_1.LimitReachedException({ type: 'u2f keys' });
    await cache.database.u2fKey.create({
        familyId: cache.familyId,
        keyId: (0, u2fkey_1.getU2fKeyId)({ keyHandle: action.keyHandle, publicKey: action.publicKey }),
        userId: parentUserId,
        addedAt: Date.now().toString(10),
        keyHandle: action.keyHandle,
        publicKey: action.publicKey,
        nextCounter: '0'
    }, { transaction: cache.transaction });
    cache.invalidateU2fList = true;
    cache.incrementTriggeredSyncLevel(1);
}
//# sourceMappingURL=addu2fkey.js.map