"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchAddCategoryNetworkId = dispatchAddCategoryNetworkId;
const categorynetworkid_1 = require("../../../../database/categorynetworkid");
const index_1 = require("../exception/index");
const missing_item_1 = require("../exception/missing-item");
async function dispatchAddCategoryNetworkId({ action, cache }) {
    const categoryEntryUnsafe = await cache.database.category.findOne({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction,
        attributes: ['childId']
    });
    if (!categoryEntryUnsafe) {
        throw new missing_item_1.MissingCategoryException();
    }
    const count = await cache.database.categoryNetworkId.count({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction
    });
    if (count + 1 > categorynetworkid_1.maxNetworkIdsPerCategory) {
        throw new index_1.ApplyActionException({
            staticMessage: 'can not add a category network id because the category network limit reached'
        });
    }
    const hasOldItem = (await cache.database.categoryNetworkId.count({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId,
            networkItemId: action.itemId
        },
        transaction: cache.transaction
    })) !== 0;
    if (hasOldItem) {
        throw new index_1.ApplyActionException({
            staticMessage: 'can not add a category network id because the id is already used'
        });
    }
    await cache.database.categoryNetworkId.create({
        familyId: cache.familyId,
        categoryId: action.categoryId,
        networkItemId: action.itemId,
        hashedNetworkId: action.hashedNetworkId
    }, { transaction: cache.transaction });
    cache.categoriesWithModifiedBaseData.add(action.categoryId);
    cache.incrementTriggeredSyncLevel(2);
}
//# sourceMappingURL=addcategorynetworkid.js.map