"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchChildAction = dispatchChildAction;
const serialization_1 = require("../../../../action/serialization");
const validator_1 = require("../../../../api/validator");
const dispatch_child_action_1 = require("../dispatch-child-action");
const helper_1 = require("./helper");
async function dispatchChildAction({ action, eventHandler, deviceId, cache, childUserId }) {
    return (0, helper_1.dispatch)({
        action,
        eventHandler,
        type: 'child',
        validator: validator_1.isSerializedChildAction,
        parser: serialization_1.parseChildAction,
        applier: async (action) => {
            await (0, dispatch_child_action_1.dispatchChildAction)({ action, cache, deviceId, childUserId });
        }
    });
}
//# sourceMappingURL=child-action.js.map