"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchAppLogicAction = dispatchAppLogicAction;
const lodash_1 = require("lodash");
const action_1 = require("../../../../action");
const serialization_1 = require("../../../../action/serialization");
const validator_1 = require("../../../../api/validator");
const dispatch_app_logic_action_1 = require("../dispatch-app-logic-action");
const helper_1 = require("./helper");
function getAppRelatedMaxValues(action) {
    if (action instanceof action_1.AddInstalledAppsAction) {
        const packageNameLength = (0, lodash_1.max)(action.apps.map((item) => item.packageName.length)) || null;
        return { packageNameLength, activityNameLength: null };
    }
    else if (action instanceof action_1.UpdateAppActivitiesAction) {
        const packageNameLength = (0, lodash_1.max)(action.updatedOrAdded.map((item) => item.packageName.length)) || null;
        const activityNameLength = (0, lodash_1.max)(action.updatedOrAdded.map((item) => item.activityName.length)) || null;
        return { packageNameLength, activityNameLength };
    }
    else
        return { packageNameLength: null, activityNameLength: null };
}
function roundCounterUp(input, factor) {
    if (input % factor === 0) {
        return input;
    }
    else {
        return input - (input % factor) + factor;
    }
}
async function dispatchAppLogicAction({ action, eventHandler, deviceId, cache }) {
    return (0, helper_1.dispatch)({
        action,
        eventHandler,
        type: 'app logic',
        validator: validator_1.isSerializedAppLogicAction,
        parser: serialization_1.parseAppLogicAction,
        applier: async (action) => {
            const maxValues = getAppRelatedMaxValues(action);
            if (maxValues.packageNameLength)
                eventHandler.reportMax('packageNameLength', roundCounterUp(maxValues.packageNameLength, 10));
            if (maxValues.activityNameLength)
                eventHandler.reportMax('activityNameLength', roundCounterUp(maxValues.activityNameLength, 10));
            await (0, dispatch_app_logic_action_1.dispatchAppLogicAction)({ action, cache, eventHandler, deviceId });
        }
    });
}
//# sourceMappingURL=app-logic-action.js.map