"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUploadDevicePublicKeyAction = dispatchUploadDevicePublicKeyAction;
const illegal_state_1 = require("../exception/illegal-state");
async function dispatchUploadDevicePublicKeyAction({ deviceId, action, cache, eventHandler }) {
    const deviceEntry = await cache.database.device.findOne({
        where: {
            familyId: cache.familyId,
            deviceId
        },
        transaction: cache.transaction
    });
    if (deviceEntry === null) {
        throw new illegal_state_1.SourceDeviceNotFoundException();
    }
    else if (deviceEntry.publicKey === null) {
        deviceEntry.publicKey = action.key;
        await deviceEntry.save({ transaction: cache.transaction });
        cache.invalidiateDeviceList = true;
        cache.incrementTriggeredSyncLevel(2);
    }
    else if (deviceEntry.publicKey.equals(action.key)) {
        eventHandler.countEvent('dispatchUploadDevicePublicKeyAction:duplicate action');
    }
    else {
        eventHandler.countEvent('dispatchUploadDevicePublicKeyAction:got new public key for existing device');
    }
}
//# sourceMappingURL=uploaddevicepublickey.js.map