"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateInstalledApps = dispatchUpdateInstalledApps;
const encryptedapplist_1 = require("../../../../database/encryptedapplist");
const token_1 = require("../../../../util/token");
async function dispatchUpdateInstalledApps({ deviceId, action, cache }) {
    async function upsert({ type, data }) {
        await cache.database.encryptedAppList.upsert({
            familyId: cache.familyId,
            deviceId,
            type,
            version: (0, token_1.generateVersionId)(),
            data
        }, { transaction: cache.transaction });
    }
    if (action.base) {
        await upsert({ type: encryptedapplist_1.types.base, data: action.base });
    }
    if (action.diff) {
        await upsert({ type: encryptedapplist_1.types.diff, data: action.diff });
    }
    cache.incrementTriggeredSyncLevel(1);
}
//# sourceMappingURL=updateinstalledapps.js.map