"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchTriedDisablingDeviceAdmin = dispatchTriedDisablingDeviceAdmin;
const device_1 = require("../../../../database/device");
const manipulation_1 = require("../../../warningmail/manipulation");
const illegal_state_1 = require("../exception/illegal-state");
async function dispatchTriedDisablingDeviceAdmin({ deviceId, cache }) {
    const deviceEntry = await cache.database.device.findOne({
        where: {
            familyId: cache.familyId,
            deviceId
        },
        transaction: cache.transaction
    });
    if (deviceEntry === null) {
        throw new illegal_state_1.SourceDeviceNotFoundException();
    }
    const hadManipulationBefore = (0, device_1.hasDeviceManipulation)(deviceEntry);
    if (!deviceEntry.triedDisablingDeviceAdmin) {
        deviceEntry.triedDisablingDeviceAdmin = true;
        await deviceEntry.save({ transaction: cache.transaction });
        cache.invalidiateDeviceList = true;
        cache.incrementTriggeredSyncLevel(1);
    }
    if (!hadManipulationBefore) {
        await (0, manipulation_1.sendManipulationWarnings)({
            database: cache.database,
            transaction: cache.transaction,
            deviceName: deviceEntry.name,
            familyId: cache.familyId
        });
    }
}
//# sourceMappingURL=trieddisablingdeviceadmin.js.map