"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchSignOutAtDevice = dispatchSignOutAtDevice;
const action_1 = require("../../../../action");
const setdeviceuser_1 = require("../dispatch-parent-action/setdeviceuser");
const illegal_state_1 = require("../exception/illegal-state");
const premium_1 = require("../exception/premium");
async function dispatchSignOutAtDevice({ deviceId, cache }) {
    if (!cache.hasFullVersion) {
        throw new premium_1.PremiumVersionMissingException();
    }
    const deviceEntry = await cache.database.device.findOne({
        where: {
            familyId: cache.familyId,
            deviceId
        },
        transaction: cache.transaction
    });
    if (!deviceEntry) {
        throw new illegal_state_1.SourceDeviceNotFoundException();
    }
    if (deviceEntry.defaultUserId === '') {
        throw new illegal_state_1.IllegalStateException({
            staticMessage: 'tried to switch to the default user where it does not exist'
        });
    }
    if (deviceEntry.currentUserId !== deviceEntry.defaultUserId) {
        await (0, setdeviceuser_1.dispatchSetDeviceUser)({
            cache,
            action: new action_1.SetDeviceUserAction({
                deviceId,
                userId: deviceEntry.defaultUserId
            })
        });
    }
    cache.incrementTriggeredSyncLevel(1);
}
//# sourceMappingURL=signoutatdevice.js.map