"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getApplyActionBaseInfo = getApplyActionBaseInfo;
const http_errors_1 = require("http-errors");
const illegal_state_1 = require("./exception/illegal-state");
async function getApplyActionBaseInfo({ database, transaction, deviceAuthToken }) {
    const deviceEntryUnsafe = await database.device.findOne({
        where: { deviceAuthToken },
        attributes: ['familyId', 'deviceId', 'nextSequenceNumber'],
        transaction
    });
    if (!deviceEntryUnsafe) {
        throw new http_errors_1.Unauthorized();
    }
    const deviceEntry = {
        familyId: deviceEntryUnsafe.familyId,
        deviceId: deviceEntryUnsafe.deviceId,
        nextSequenceNumber: deviceEntryUnsafe.nextSequenceNumber
    };
    const familyEntryUnsafe = await database.family.findOne({
        where: {
            familyId: deviceEntry.familyId
        },
        transaction,
        attributes: ['hasFullVersion']
    });
    if (!familyEntryUnsafe) {
        throw new illegal_state_1.SourceFamilyNotFoundException();
    }
    const familyEntry = {
        hasFullVersion: familyEntryUnsafe.hasFullVersion
    };
    return {
        familyId: deviceEntry.familyId,
        deviceId: deviceEntry.deviceId,
        nextSequenceNumber: deviceEntry.nextSequenceNumber,
        hasFullVersion: familyEntry.hasFullVersion
    };
}
//# sourceMappingURL=baseinfo.js.map