"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isGooglePlayPurchaseSignatureValid = exports.areGooglePlayPaymentsPossible = exports.googlePlayPublicKey = void 0;
const iab_verifierr_1 = require("./iab_verifierr");
exports.googlePlayPublicKey = process.env.GOOGLE_PLAY_PUBLIC_KEY || '';
const verifier = exports.googlePlayPublicKey !== '' ? new iab_verifierr_1.IABVerifier(exports.googlePlayPublicKey) : null;
exports.areGooglePlayPaymentsPossible = !!verifier;
const isGooglePlayPurchaseSignatureValid = ({ receipt, signature }) => {
    if (verifier) {
        return verifier.verifyReceipt(receipt, signature);
    }
    else {
        return false;
    }
};
exports.isGooglePlayPurchaseSignatureValid = isGooglePlayPurchaseSignatureValid;
//# sourceMappingURL=verification.js.map