"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPurchase = exports.googlePlayPublicKey = exports.areGooglePlayPaymentsPossible = exports.isGooglePlayPurchaseSignatureValid = exports.requireFamilyEntry = exports.canDoNextPurchase = void 0;
var can_do_next_purchase_1 = require("./can-do-next-purchase");
Object.defineProperty(exports, "canDoNextPurchase", { enumerable: true, get: function () { return can_do_next_purchase_1.canDoNextPurchase; } });
var require_family_entry_1 = require("./require-family-entry");
Object.defineProperty(exports, "requireFamilyEntry", { enumerable: true, get: function () { return require_family_entry_1.requireFamilyEntry; } });
var verification_1 = require("./verification");
Object.defineProperty(exports, "isGooglePlayPurchaseSignatureValid", { enumerable: true, get: function () { return verification_1.isGooglePlayPurchaseSignatureValid; } });
Object.defineProperty(exports, "areGooglePlayPaymentsPossible", { enumerable: true, get: function () { return verification_1.areGooglePlayPaymentsPossible; } });
Object.defineProperty(exports, "googlePlayPublicKey", { enumerable: true, get: function () { return verification_1.googlePlayPublicKey; } });
var add_purchase_1 = require("./add-purchase");
Object.defineProperty(exports, "addPurchase", { enumerable: true, get: function () { return add_purchase_1.addPurchase; } });
//# sourceMappingURL=index.js.map