"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.addPurchase = void 0;
const http_errors_1 = require("http-errors");
const websocket_1 = require("../../function/websocket");
const day = 1000 * 60 * 60 * 24;
const month = day * 31;
const year = day * 366;
const addPurchase = async ({ database, familyId, type, service, transactionId, websocket, transaction }) => {
    const oldPurchaseEntry = await database.purchase.findOne({
        where: {
            service,
            transactionId
        },
        transaction
    });
    if (oldPurchaseEntry) {
        return;
    }
    const familyEntry = await database.family.findOne({
        where: {
            familyId
        },
        transaction
    });
    if (!familyEntry) {
        throw new http_errors_1.Conflict();
    }
    const previousFullVersionEndTime = familyEntry.fullVersionUntil;
    const newFullVersionUntil = Math.max(parseInt(familyEntry.fullVersionUntil, 10), Date.now()) + (type === 'year' ? year : month);
    familyEntry.fullVersionUntil = newFullVersionUntil.toString(10);
    familyEntry.hasFullVersion = true;
    await familyEntry.save({ transaction });
    await database.purchase.create({
        familyId,
        service,
        transactionId,
        type,
        loggedAt: Date.now().toString(10),
        previousFullVersionEndTime,
        newFullVersionEndTime: newFullVersionUntil.toString(10)
    }, {
        transaction
    });
    await (0, websocket_1.notifyClientsAboutChangesDelayed)({
        familyId,
        sourceDeviceId: null,
        database,
        websocket,
        generalLevel: 2,
        targetedLevels: new Map(),
        transaction
    });
};
exports.addPurchase = addPurchase;
//# sourceMappingURL=add-purchase.js.map