"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStatusByMailToken = void 0;
const exception_1 = require("../../exception");
const authentication_1 = require("../authentication");
const getStatusByMailAddress = async ({ mail, database, transaction }) => {
    if (!mail) {
        throw new exception_1.StaticMessageException({ staticMessage: 'getStatusByMailAddress: no mail address provided' });
    }
    const entry = await database.user.findOne({
        where: {
            mail
        },
        transaction
    });
    if (entry) {
        return 'with family';
    }
    else {
        return 'without family';
    }
};
const getStatusByMailToken = async ({ mailAuthToken, database, transaction }) => {
    const mailInfo = await (0, authentication_1.requireMailAndLocaleByAuthToken)({ mailAuthToken, database, transaction, invalidate: false });
    const mail = mailInfo.mail;
    const status = await getStatusByMailAddress({ mail, database, transaction });
    return { mail, status };
};
exports.getStatusByMailToken = getStatusByMailToken;
//# sourceMappingURL=get-status-by-mail-address.js.map