"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAddDeviceToken = void 0;
const random_words_1 = require("../../util/random-words");
const token_1 = require("../../util/token");
const createAddDeviceToken = async ({ familyId, database, transaction }) => {
    const token = (0, random_words_1.randomWords)(5);
    const deviceId = (0, token_1.generateIdWithinFamily)();
    await database.addDeviceToken.destroy({
        where: {
            familyId
        },
        transaction
    });
    await database.addDeviceToken.create({
        familyId,
        token: token.toLowerCase(),
        deviceId,
        createdAt: Date.now().toString()
    }, { transaction });
    return { token, deviceId };
};
exports.createAddDeviceToken = createAddDeviceToken;
//# sourceMappingURL=create-add-device-token.js.map