"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2023 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareDeviceEntry = void 0;
const token_1 = require("../../util/token");
const prepareDeviceEntry = ({ familyId, userId, deviceAuthToken, deviceId, deviceName, newDeviceInfo, isUserKeptSignedIn }) => ({
    familyId,
    deviceId,
    currentUserId: userId,
    installedAppsVersion: (0, token_1.generateVersionId)(),
    name: deviceName,
    model: newDeviceInfo.model,
    addedAt: Date.now().toString(10),
    deviceAuthToken,
    networkTime: 'disabled',
    nextSequenceNumber: 0,
    currentProtectionLevel: 'none',
    highestProtectionLevel: 'none',
    currentUsageStatsPermission: 'not granted',
    highestUsageStatsPermission: 'not granted',
    currentNotificationAccessPermission: 'not granted',
    highestNotificationAccessPermission: 'not granted',
    currentAppVersion: 0,
    highestAppVersion: 0,
    triedDisablingDeviceAdmin: false,
    didReboot: false,
    hadManipulation: false,
    hadManipulationFlags: 0,
    lastConnectivity: '0',
    notSeenForLongTime: false,
    didDeviceReportUninstall: false,
    isUserKeptSignedIn,
    showDeviceConnected: false,
    defaultUserId: '',
    defaultUserTimeout: 0,
    considerRebootManipulation: false,
    currentOverlayPermission: 'not granted',
    highestOverlayPermission: 'not granted',
    asEnabled: false,
    wasAsEnabled: false,
    activityLevelBlocking: false,
    isQorLater: false,
    manipulationFlags: 0,
    publicKey: null,
    nextKeyReplySequenceNumber: '1',
    platformType: null,
    platformLevel: 0
});
exports.prepareDeviceEntry = prepareDeviceEntry;
//# sourceMappingURL=prepare-device-entry.js.map