"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.logoutAtPrimaryDevice = void 0;
const http_errors_1 = require("http-errors");
const logoutAtPrimaryDevice = async ({ deviceAuthToken, database, websocket }) => {
    await database.transaction(async (transaction) => {
        const ownDeviceEntryUnsafe = await database.device.findOne({
            where: {
                deviceAuthToken
            },
            transaction,
            attributes: ['familyId', 'currentUserId', 'deviceId']
        });
        if (!ownDeviceEntryUnsafe) {
            throw new http_errors_1.Unauthorized();
        }
        const ownDeviceEntry = {
            familyId: ownDeviceEntryUnsafe.familyId,
            currentUserId: ownDeviceEntryUnsafe.currentUserId
        };
        const deviceUserEntryUnsafe = await database.user.findOne({
            where: {
                familyId: ownDeviceEntry.familyId,
                userId: ownDeviceEntry.currentUserId,
                type: 'child'
            },
            attributes: ['currentDevice'],
            transaction
        });
        if (!deviceUserEntryUnsafe) {
            throw new http_errors_1.Conflict();
        }
        const deviceUserEntry = {
            currentDevice: deviceUserEntryUnsafe.currentDevice
        };
        const otherDeviceEntryUnsafe = await database.device.findOne({
            where: {
                familyId: ownDeviceEntry.familyId,
                deviceId: deviceUserEntry.currentDevice,
                currentUserId: ownDeviceEntry.currentUserId
            },
            attributes: ['deviceAuthToken'],
            transaction
        });
        if (!otherDeviceEntryUnsafe) {
            throw new http_errors_1.Conflict();
        }
        const otherDeviceEntry = {
            deviceAuthToken: otherDeviceEntryUnsafe.deviceAuthToken
        };
        websocket.triggerLogoutByDeviceAuthToken({
            deviceAuthToken: otherDeviceEntry.deviceAuthToken
        });
    });
};
exports.logoutAtPrimaryDevice = logoutAtPrimaryDevice;
//# sourceMappingURL=logout-at-primary-device.js.map