"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.addChildDevice = void 0;
const http_errors_1 = require("http-errors");
const token_1 = require("../../util/token");
const prepare_device_entry_1 = require("../device/prepare-device-entry");
const websocket_1 = require("../websocket");
const get_server_data_status_1 = require("../sync/get-server-data-status");
const clientdatastatus_1 = require("../../object/clientdatastatus");
const addChildDevice = async ({ database, eventHandler, websocket, request }) => {
    return database.transaction(async (transaction) => {
        const entry = await database.addDeviceToken.findOne({
            where: {
                token: request.registerToken.toLowerCase()
            },
            transaction
        });
        if (!entry) {
            throw new http_errors_1.Unauthorized();
        }
        await entry.destroy({ transaction });
        const { deviceId, familyId } = entry;
        const deviceAuthToken = (0, token_1.generateAuthToken)();
        await database.device.create((0, prepare_device_entry_1.prepareDeviceEntry)({
            familyId,
            deviceId,
            deviceAuthToken,
            deviceName: request.deviceName,
            newDeviceInfo: request.childDevice,
            userId: '',
            isUserKeptSignedIn: false
        }), { transaction });
        await database.family.update({
            deviceListVersion: (0, token_1.generateVersionId)()
        }, {
            where: {
                familyId
            },
            transaction
        });
        await (0, websocket_1.notifyClientsAboutChangesDelayed)({
            familyId,
            websocket,
            database,
            generalLevel: 1,
            targetedLevels: new Map(),
            sourceDeviceId: deviceId,
            transaction
        });
        const data = await (0, get_server_data_status_1.generateServerDataStatus)({
            database,
            clientStatus: (0, clientdatastatus_1.createEmptyClientDataStatus)({ clientLevel: request.clientLevel || null }),
            familyId: entry.familyId,
            deviceId,
            transaction,
            eventHandler
        });
        return {
            deviceId,
            deviceAuthToken,
            data
        };
    });
};
exports.addChildDevice = addChildDevice;
//# sourceMappingURL=add-device.js.map