"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUserLimitLoginCategoryModel = exports.attributes = exports.attributesVersion2 = exports.attributesVersion1 = exports.maxPreBlockDuration = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.maxPreBlockDuration = 1000 * 60 * 60 * 24; // 1 day
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    userId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    categoryId: Object.assign({}, columns_1.idWithinFamilyColumn)
};
exports.attributesVersion2 = {
    preBlockDuration: {
        type: Sequelize.INTEGER,
        validate: {
            min: 0,
            max: exports.maxPreBlockDuration
        },
        allowNull: false,
        defaultValue: 0
    }
};
exports.attributes = Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2);
const createUserLimitLoginCategoryModel = (sequelize) => sequelize.define('UserLimitLoginCategory', exports.attributes);
exports.createUserLimitLoginCategoryModel = createUserLimitLoginCategoryModel;
//# sourceMappingURL=userlimitlogincategory.js.map