"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUserModel = exports.attributes = exports.attributesVersion6 = exports.attributesVersion5 = exports.attributesVersion4 = exports.attributesVersion3 = exports.attributesVersion2 = exports.attributesVersion1 = exports.mailNotificationFlags = exports.maxMailNotificationFlags = void 0;
const Sequelize = require("sequelize");
const userflags_1 = require("../model/userflags");
const bitmask_1 = require("../util/bitmask");
const password_1 = require("../util/password");
const columns_1 = require("./columns");
exports.maxMailNotificationFlags = 1 | 2;
exports.mailNotificationFlags = {
    warnings: 1,
    tasks: 2
};
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    userId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    name: Object.assign({}, columns_1.labelColumn),
    passwordHash: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
            is: password_1.optionalPasswordRegex
        }
    },
    secondPasswordHash: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
            is: password_1.optionalPasswordRegex
        }
    },
    secondPasswordSalt: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
            is: password_1.optionalSaltRegex
        }
    },
    type: (0, columns_1.createEnumColumn)(['parent', 'child']),
    mail: {
        type: Sequelize.STRING,
        allowNull: false
    },
    timeZone: Object.assign({}, columns_1.labelColumn),
    disableTimelimitsUntil: Object.assign({}, columns_1.timestampColumn),
    currentDevice: Object.assign({}, columns_1.optionalIdWithinFamilyColumn)
};
exports.attributesVersion2 = {
    categoryForNotAssignedApps: Object.assign(Object.assign({}, columns_1.optionalIdWithinFamilyColumn), { defaultValue: '' })
};
exports.attributesVersion3 = {
    relaxPrimaryDeviceRule: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion4 = {
    mailNotificationFlags: {
        type: Sequelize.INTEGER,
        defaultValue: 0,
        validate: {
            min: 0,
            max: exports.maxMailNotificationFlags
        }
    }
};
exports.attributesVersion5 = {
    blockedTimes: {
        type: Sequelize.TEXT,
        allowNull: false,
        defaultValue: '',
        validate: {
            is: bitmask_1.serializedBitmaskRegex
        }
    }
};
exports.attributesVersion6 = {
    flags: {
        type: Sequelize.BIGINT,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0,
            max: userflags_1.UserFlags.ALL_FLAGS
        }
    }
};
exports.attributes = Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2), exports.attributesVersion3), exports.attributesVersion4), exports.attributesVersion5), exports.attributesVersion6);
const createUserModel = (sequelize) => sequelize.define('User', exports.attributes);
exports.createUserModel = createUserModel;
//# sourceMappingURL=user.js.map