"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const sequelize_1 = require("sequelize");
const minuteofday_1 = require("../../../util/minuteofday");
const sessionduration_1 = require("../../sessionduration");
const timelimitrule_1 = require("../../timelimitrule");
const usedtime_1 = require("../../usedtime");
async function up(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        // session durations
        await queryInterface.createTable('SessionDurations', sessionduration_1.attributesVersion1, { transaction });
        // timelimit rule table
        await queryInterface.addColumn('TimelimitRules', 'startMinuteOfDay', Object.assign({}, timelimitrule_1.attributesVersion2.startMinuteOfDay), { transaction });
        await queryInterface.addColumn('TimelimitRules', 'endMinuteOfDay', Object.assign({}, timelimitrule_1.attributesVersion2.endMinuteOfDay), { transaction });
        await queryInterface.addColumn('TimelimitRules', 'sessionDurationMilliseconds', Object.assign({}, timelimitrule_1.attributesVersion2.sessionDurationMilliseconds), { transaction });
        await queryInterface.addColumn('TimelimitRules', 'sessionPauseMilliseconds', Object.assign({}, timelimitrule_1.attributesVersion2.sessionPauseMilliseconds), { transaction });
        // used times
        await queryInterface.renameTable('UsedTimes', 'UsedTimesOld', { transaction });
        await queryInterface.createTable('UsedTimes', Object.assign(Object.assign(Object.assign({}, usedtime_1.attributesVersion1), usedtime_1.attributesVersion2), usedtime_1.attributesVersion3), { transaction });
        const dialect = sequelize.getDialect();
        const isMysql = dialect === 'mysql' || dialect === 'mariadb';
        if (isMysql) {
            await sequelize.query(`
        INSERT INTO UsedTimes (familyId, categoryId, dayOfEpoch, usedTime, lastUpdate, startMinuteOfDay, endMinuteOfDay)
          SELECT familyId, categoryId, dayOfEpoch, usedTime, lastUpdate,
          ${minuteofday_1.MinuteOfDay.MIN} AS startMinuteOfDay, ${minuteofday_1.MinuteOfDay.MAX} AS endMinuteOfDay
          FROM UsedTimesOld
      `, { transaction });
        }
        else {
            await sequelize.query(`
        INSERT INTO "UsedTimes" ("familyId", "categoryId", "dayOfEpoch", "usedTime", "lastUpdate", "startMinuteOfDay", "endMinuteOfDay")
          SELECT "familyId", "categoryId", "dayOfEpoch", "usedTime", "lastUpdate",
          ${minuteofday_1.MinuteOfDay.MIN} AS "startMinuteOfDay", ${minuteofday_1.MinuteOfDay.MAX} AS "endMinuteOfDay"
          FROM "UsedTimesOld"
      `, { transaction });
        }
        await queryInterface.dropTable('UsedTimesOld', { transaction });
    });
}
async function down(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        // session durations
        await queryInterface.dropTable('SessionDurations', { transaction });
        // timelimit rule table
        await queryInterface.removeColumn('TimelimitRules', 'startMinuteOfDay', { transaction });
        await queryInterface.removeColumn('TimelimitRules', 'endMinuteOfDay', { transaction });
        await queryInterface.removeColumn('TimelimitRules', 'sessionDurationMilliseconds', { transaction });
        await queryInterface.removeColumn('TimelimitRules', 'sessionPauseMilliseconds', { transaction });
        // used times
        throw new Error('not implemented');
    });
}
//# sourceMappingURL=20200525-add-new-limit-options.js.map