"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const sequelize_1 = require("sequelize");
const adddevicetoken_1 = require("../../adddevicetoken");
const app_1 = require("../../app");
const authtoken_1 = require("../../authtoken");
const category_1 = require("../../category");
const categoryapp_1 = require("../../categoryapp");
const device_1 = require("../../device");
const family_1 = require("../../family");
const purchase_1 = require("../../purchase");
const timelimitrule_1 = require("../../timelimitrule");
const usedtime_1 = require("../../usedtime");
const user_1 = require("../../user");
async function up(queryInterface, sequelize) {
    await sequelize.transaction({
        type: sequelize_1.Transaction.TYPES.EXCLUSIVE
    }, async (transaction) => {
        await queryInterface.createTable('AddDeviceTokens', adddevicetoken_1.attributes, { transaction });
        await queryInterface.createTable('Apps', app_1.attributes, { transaction });
        await queryInterface.createTable('AuthTokens', authtoken_1.attributesVersion1, { transaction });
        await queryInterface.createTable('Categories', category_1.attributesVersion1, { transaction });
        await queryInterface.createTable('CategoryApps', categoryapp_1.attributes, { transaction });
        await queryInterface.createTable('Devices', device_1.attributesVersion1, { transaction });
        await queryInterface.createTable('Families', family_1.attributesVersion1, { transaction });
        await queryInterface.createTable('Purchases', purchase_1.attributes, { transaction });
        await queryInterface.createTable('TimelimitRules', timelimitrule_1.attributesVersion1, { transaction });
        await queryInterface.createTable('UsedTimes', usedtime_1.attributesVersion1, { transaction });
        await queryInterface.createTable('Users', user_1.attributesVersion1, { transaction });
    });
}
async function down() {
    throw new Error('not possible');
}
//# sourceMappingURL=20181014-setup-tables.js.map