"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFamilyModel = exports.attributes = exports.attributesVersion3 = exports.attributesVersion2 = exports.attributesVersion1 = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    name: Object.assign({}, columns_1.optionalLabelColumn),
    createdAt: Object.assign({}, columns_1.timestampColumn),
    userListVersion: Object.assign({}, columns_1.versionColumn),
    deviceListVersion: Object.assign({}, columns_1.versionColumn),
    fullVersionUntil: Object.assign({}, columns_1.timestampColumn),
    hasFullVersion: Object.assign({}, columns_1.booleanColumn)
};
exports.attributesVersion2 = {
    nextServerKeyRequestSeq: {
        type: Sequelize.BIGINT,
        allowNull: false,
        defaultValue: 1,
        validate: {
            min: 1
        }
    }
};
exports.attributesVersion3 = {
    u2fKeysVersion: Object.assign(Object.assign({}, columns_1.versionColumn), { defaultValue: '0000' })
};
exports.attributes = Object.assign(Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2), exports.attributesVersion3);
const createFamilyModel = (sequelize) => sequelize.define('Family', exports.attributes);
exports.createFamilyModel = createFamilyModel;
//# sourceMappingURL=family.js.map