"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2024 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeviceDhKey = exports.attributes = exports.attributesVersion2 = exports.attributesVersion1 = exports.config = void 0;
exports.calculateExpireTime = calculateExpireTime;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.config = {
    generateNewKeyAfterAge: 1000 * 60 * 60 * 24,
    generationTimeRounding: 1000 * 60 * 60,
    expireDelay: 1000 * 60 * 60 * 2,
    expireTimeRounding: 1000 * 60 * 15
};
function calculateExpireTime(now) {
    const expireBaseTime = now + BigInt(exports.config.expireDelay);
    const expireTime = expireBaseTime - expireBaseTime % BigInt(exports.config.expireTimeRounding) + BigInt(exports.config.expireTimeRounding);
    return expireTime;
}
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    deviceId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    version: Object.assign(Object.assign({}, columns_1.versionColumn), { primaryKey: true }),
    createdAt: Object.assign({}, columns_1.timestampColumn),
    expireAt: Object.assign(Object.assign({}, columns_1.timestampColumn), { allowNull: true }),
    publicKey: {
        type: Sequelize.BLOB,
        allowNull: false
    },
    privateKey: {
        type: Sequelize.BLOB,
        allowNull: false
    }
};
exports.attributesVersion2 = {
    createdAtSubsequence: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: 0
    }
};
exports.attributes = Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2);
const createDeviceDhKey = (sequelize) => sequelize.define('DeviceDhKey', exports.attributes);
exports.createDeviceDhKey = createDeviceDhKey;
//# sourceMappingURL=devicedhkey.js.map