"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2023 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasDeviceManipulation = exports.createDeviceModel = exports.attributes = exports.attributesVersion15 = exports.attributesVersion14 = exports.attributesVersion13 = exports.attributesVersion12 = exports.attributesVersion11 = exports.attributesVersion10 = exports.attributesVersion9 = exports.attributesVersion8 = exports.attributesVersion7 = exports.attributesVersion6 = exports.attributesVersion5 = exports.attributesVersion4 = exports.attributesVersion3 = exports.attributesVersion2 = exports.attributesVersion1 = exports.maxPlatformLevel = exports.minPlatformLevel = exports.maxPlatformTypeLength = exports.minPlatformTypeLength = exports.DeviceManipulationFlags = exports.DeviceHadManipulationFlags = void 0;
const Sequelize = require("sequelize");
const newpermissionstatus_1 = require("../model/newpermissionstatus");
const protectionlevel_1 = require("../model/protectionlevel");
const runtimepermissionstatus_1 = require("../model/runtimepermissionstatus");
const columns_1 = require("./columns");
exports.DeviceHadManipulationFlags = {
    ProtectionLevel: 1,
    UsageStatsAccess: 2,
    NotificationAccess: 4,
    AppVersion: 8,
    OverlayPermission: 16,
    AccessibiityService: 32,
    ALL: 1 | 2 | 4 | 8 | 16 | 32
};
exports.DeviceManipulationFlags = {
    USED_FGS_KILLER: 1,
    ALL: 1
};
exports.minPlatformTypeLength = 1;
exports.maxPlatformTypeLength = 8;
exports.minPlatformLevel = 0;
exports.maxPlatformLevel = 128;
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    deviceId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    name: Object.assign({}, columns_1.labelColumn),
    model: Object.assign({}, columns_1.labelColumn),
    addedAt: Object.assign({}, columns_1.timestampColumn),
    currentUserId: Object.assign({}, columns_1.optionalIdWithinFamilyColumn),
    installedAppsVersion: Object.assign({}, columns_1.versionColumn),
    deviceAuthToken: Object.assign({}, columns_1.authTokenColumn),
    networkTime: (0, columns_1.createEnumColumn)(['disabled', 'if possible', 'enabled']),
    nextSequenceNumber: {
        type: Sequelize.INTEGER,
        allowNull: false
    },
    currentProtectionLevel: (0, columns_1.createEnumColumn)(protectionlevel_1.protetionLevels),
    highestProtectionLevel: (0, columns_1.createEnumColumn)(protectionlevel_1.protetionLevels),
    currentUsageStatsPermission: (0, columns_1.createEnumColumn)(runtimepermissionstatus_1.runtimePermissionStatusValues),
    highestUsageStatsPermission: (0, columns_1.createEnumColumn)(runtimepermissionstatus_1.runtimePermissionStatusValues),
    currentNotificationAccessPermission: (0, columns_1.createEnumColumn)(newpermissionstatus_1.newPermissionStatusValues),
    highestNotificationAccessPermission: (0, columns_1.createEnumColumn)(newpermissionstatus_1.newPermissionStatusValues),
    currentAppVersion: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            min: 0
        }
    },
    highestAppVersion: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            min: 0
        }
    },
    triedDisablingDeviceAdmin: Object.assign({}, columns_1.booleanColumn),
    hadManipulation: Object.assign({}, columns_1.booleanColumn)
};
exports.attributesVersion2 = {
    lastConnectivity: Object.assign(Object.assign({}, columns_1.timestampColumn), { defaultValue: 0 }),
    notSeenForLongTime: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false }),
    didDeviceReportUninstall: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion3 = {
    isUserKeptSignedIn: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion4 = {
    showDeviceConnected: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion5 = {
    defaultUserId: Object.assign(Object.assign({}, columns_1.optionalIdWithinFamilyColumn), { defaultValue: '' }),
    defaultUserTimeout: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0
        }
    }
};
exports.attributesVersion6 = {
    didReboot: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false }),
    considerRebootManipulation: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion7 = {
    currentOverlayPermission: Object.assign(Object.assign({}, (0, columns_1.createEnumColumn)(runtimepermissionstatus_1.runtimePermissionStatusValues)), { defaultValue: 'not granted' }),
    highestOverlayPermission: Object.assign(Object.assign({}, (0, columns_1.createEnumColumn)(runtimepermissionstatus_1.runtimePermissionStatusValues)), { defaultValue: 'not granted' })
};
exports.attributesVersion8 = {
    asEnabled: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false }),
    wasAsEnabled: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion9 = {
    activityLevelBlocking: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion10 = {
    isQorLater: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion11 = {
    hadManipulationFlags: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0,
            max: exports.DeviceHadManipulationFlags.ALL
        }
    }
};
exports.attributesVersion12 = {
    manipulationFlags: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0,
            max: exports.DeviceManipulationFlags.ALL
        }
    }
};
exports.attributesVersion13 = {
    publicKey: {
        type: Sequelize.BLOB,
        allowNull: true,
        defaultValue: null
    }
};
exports.attributesVersion14 = {
    nextKeyReplySequenceNumber: {
        type: Sequelize.BIGINT,
        allowNull: false,
        defaultValue: 1
    }
};
exports.attributesVersion15 = {
    platformType: {
        type: Sequelize.STRING(exports.maxPlatformTypeLength),
        allowNull: true,
        defaultValue: null,
        validate: {
            len: [exports.minPlatformTypeLength, exports.maxPlatformTypeLength]
        }
    },
    platformLevel: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: exports.minPlatformLevel,
        validate: {
            min: exports.minPlatformLevel,
            max: exports.maxPlatformLevel
        }
    }
};
exports.attributes = Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2), exports.attributesVersion3), exports.attributesVersion4), exports.attributesVersion5), exports.attributesVersion6), exports.attributesVersion7), exports.attributesVersion8), exports.attributesVersion9), exports.attributesVersion10), exports.attributesVersion11), exports.attributesVersion12), exports.attributesVersion13), exports.attributesVersion14), exports.attributesVersion15);
const createDeviceModel = (sequelize) => sequelize.define('Device', exports.attributes);
exports.createDeviceModel = createDeviceModel;
const hasDeviceManipulation = (device) => {
    const manipulationOfProtectionLevel = device.currentProtectionLevel !== device.highestProtectionLevel;
    const manipulationOfUsageStats = device.currentUsageStatsPermission !== device.highestUsageStatsPermission;
    const manipulationOfNotificationAccess = device.currentNotificationAccessPermission !== device.highestNotificationAccessPermission;
    const manipulationOfAppVersion = device.currentAppVersion !== device.highestAppVersion;
    const manipulationOfOverlayPermission = device.currentOverlayPermission !== device.highestOverlayPermission;
    const manipulationOfAsPermission = device.asEnabled !== device.wasAsEnabled;
    const hasActiveManipulationWarning = manipulationOfProtectionLevel ||
        manipulationOfUsageStats ||
        manipulationOfNotificationAccess ||
        manipulationOfAppVersion ||
        device.triedDisablingDeviceAdmin ||
        device.didReboot ||
        manipulationOfOverlayPermission ||
        manipulationOfAsPermission;
    const hasAnyManipulation = hasActiveManipulationWarning || device.hadManipulation ||
        device.manipulationFlags !== 0;
    return hasAnyManipulation;
};
exports.hasDeviceManipulation = hasDeviceManipulation;
//# sourceMappingURL=device.js.map