"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.configItemIds = exports.createConfigModel = exports.attributes = void 0;
const Sequelize = require("sequelize");
exports.attributes = {
    id: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
            notEmpty: true
        },
        primaryKey: true
    },
    value: {
        type: Sequelize.STRING,
        allowNull: false
    }
};
const createConfigModel = (sequelize) => sequelize.define('Config', exports.attributes);
exports.createConfigModel = createConfigModel;
exports.configItemIds = {
    statusMessage: 'status_message',
    selfTestData: 'self_test_data',
    secondSelfTestData: 'self_test_data_two'
};
//# sourceMappingURL=config.js.map