"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.authTokenColumn = exports.booleanColumn = exports.timestampColumn = exports.createEnumColumn = exports.optionalLabelColumn = exports.labelColumn = exports.versionColumn = exports.optionalIdWithinFamilyColumn = exports.idWithinFamilyColumn = exports.familyIdColumn = void 0;
const Sequelize = require("sequelize");
exports.familyIdColumn = {
    type: Sequelize.STRING(10),
    allowNull: false,
    validate: {
        notEmpty: true,
        is: /^[a-zA-Z0-9]{10}$/
    }
};
exports.idWithinFamilyColumn = {
    type: Sequelize.STRING(6),
    allowNull: false,
    validate: {
        notEmpty: true,
        is: /^[a-zA-Z0-9]{6}$/
    }
};
exports.optionalIdWithinFamilyColumn = {
    type: Sequelize.STRING(6),
    allowNull: false,
    validate: {
        is: /^([a-zA-Z0-9]{6})?$/
    }
};
exports.versionColumn = {
    type: Sequelize.STRING(4),
    allowNull: false,
    validate: {
        notEmpty: true,
        is: /^[a-zA-Z0-9]{4}$/
    }
};
exports.labelColumn = {
    type: Sequelize.STRING,
    allowNull: false,
    validate: {
        notEmpty: true
    }
};
exports.optionalLabelColumn = {
    type: Sequelize.STRING,
    allowNull: false
};
const createEnumColumn = (possibleValues) => ({
    type: Sequelize.STRING,
    allowNull: false,
    validate: {
        isIn: [possibleValues],
        notEmpty: true
    }
});
exports.createEnumColumn = createEnumColumn;
// warning: this results in an string field
exports.timestampColumn = {
    type: Sequelize.BIGINT,
    allowNull: false,
    validate: {
        min: 0
    }
};
exports.booleanColumn = {
    type: Sequelize.BOOLEAN,
    allowNull: false
};
exports.authTokenColumn = {
    type: Sequelize.STRING(32),
    allowNull: false,
    validate: {
        notEmpty: true,
        is: /^[a-zA-Z0-9]{32}$/
    }
};
//# sourceMappingURL=columns.js.map