"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createChildTaskModel = exports.attributes = exports.maxTitleLength = exports.maxExtraTime = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.maxExtraTime = 1000 * 60 * 60 * 24;
exports.maxTitleLength = 50;
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    taskId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    categoryId: Object.assign({}, columns_1.idWithinFamilyColumn),
    taskTitle: {
        type: Sequelize.STRING(exports.maxTitleLength),
        allowNull: false
    },
    extraTimeDuration: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: { min: 1, max: exports.maxExtraTime }
    },
    pendingRequest: {
        type: Sequelize.INTEGER,
        allowNull: false
    },
    lastGrantTimestamp: Object.assign({}, columns_1.timestampColumn)
};
const createChildTaskModel = (sequelize) => sequelize.define('ChildTask', exports.attributes);
exports.createChildTaskModel = createChildTaskModel;
//# sourceMappingURL=childtask.js.map