"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCategoryTimeWarningModel = exports.attributes = exports.categoryTimeWarningConstants = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.categoryTimeWarningConstants = {
    minMinutes: 1,
    maxMinutes: 60 * 24 * 7 - 2
};
exports.attributes = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    categoryId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    minutes: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            min: exports.categoryTimeWarningConstants.minMinutes,
            max: exports.categoryTimeWarningConstants.maxMinutes
        },
        primaryKey: true
    }
};
const createCategoryTimeWarningModel = (sequelize) => sequelize.define('CategoryTimeWarning', exports.attributes);
exports.createCategoryTimeWarningModel = createCategoryTimeWarningModel;
//# sourceMappingURL=categorytimewarning.js.map