"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCategoryModel = exports.attributes = exports.attributesVersion12 = exports.attributesVersion11 = exports.attributesVersion10 = exports.attributesVersion9 = exports.attributesVersion8 = exports.attributesVersion7 = exports.attributesVersion6 = exports.attributesVersion5 = exports.attributesVersion4 = exports.attributesVersion3 = exports.attributesVersion2 = exports.attributesVersion1 = exports.maxCategoryFlags = exports.categoryFlags = exports.allowedTimeWarningFlags = void 0;
const Sequelize = require("sequelize");
const bitmask_1 = require("../util/bitmask");
const columns_1 = require("./columns");
exports.allowedTimeWarningFlags = 1 | 2 | 4 | 8 | 16;
exports.categoryFlags = {
    hasBlockedNetworkList: 1
};
exports.maxCategoryFlags = exports.categoryFlags.hasBlockedNetworkList;
exports.attributesVersion1 = {
    familyId: Object.assign(Object.assign({}, columns_1.familyIdColumn), { primaryKey: true }),
    categoryId: Object.assign(Object.assign({}, columns_1.idWithinFamilyColumn), { primaryKey: true }),
    childId: Object.assign({}, columns_1.idWithinFamilyColumn),
    title: Object.assign({}, columns_1.labelColumn),
    blockedMinutesInWeek: {
        type: Sequelize.TEXT,
        allowNull: false,
        validate: {
            is: bitmask_1.serializedBitmaskRegex
        }
    },
    extraTimeInMillis: {
        type: Sequelize.INTEGER,
        allowNull: false,
        validate: {
            min: 0
        }
    },
    temporarilyBlocked: Object.assign({}, columns_1.booleanColumn),
    baseVersion: Object.assign({}, columns_1.versionColumn),
    assignedAppsVersion: Object.assign({}, columns_1.versionColumn),
    timeLimitRulesVersion: Object.assign({}, columns_1.versionColumn),
    usedTimesVersion: Object.assign({}, columns_1.versionColumn)
};
exports.attributesVersion2 = {
    parentCategoryId: Object.assign(Object.assign({}, columns_1.optionalIdWithinFamilyColumn), { defaultValue: '' })
};
exports.attributesVersion3 = {
    blockAllNotifications: Object.assign(Object.assign({}, columns_1.booleanColumn), { defaultValue: false })
};
exports.attributesVersion4 = {
    timeWarningFlags: {
        type: Sequelize.INTEGER,
        defaultValue: 0,
        allowNull: false,
        validate: {
            min: 0,
            max: exports.allowedTimeWarningFlags
            // 1 => 1 minute
            // 2 => 3 minutes
            // 4 => 5 minutes
            // 8 => 10 minutes
            // 16 => 15 minutes
        }
    }
};
exports.attributesVersion5 = {
    minBatteryMobile: {
        type: Sequelize.INTEGER,
        defaultValue: 0,
        allowNull: false,
        validate: {
            min: 0,
            max: 100
        }
    },
    minBatteryCharging: {
        type: Sequelize.INTEGER,
        defaultValue: 0,
        allowNull: false,
        validate: {
            min: 0,
            max: 100
        }
    }
};
exports.attributesVersion6 = {
    temporarilyBlockedEndTime: Object.assign(Object.assign({}, columns_1.timestampColumn), { defaultValue: 0 })
};
exports.attributesVersion7 = {
    sort: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0
        }
    }
};
exports.attributesVersion8 = {
    extraTimeDay: {
        type: Sequelize.INTEGER,
        allowNull: false,
        defaultValue: -1,
        validate: {
            min: -1
        }
    }
};
exports.attributesVersion9 = {
    disableLimitsUntil: Object.assign(Object.assign({}, columns_1.timestampColumn), { defaultValue: 0 })
};
exports.attributesVersion10 = {
    taskListVersion: Object.assign(Object.assign({}, columns_1.versionColumn), { defaultValue: 'abcd' })
};
exports.attributesVersion11 = {
    flags: {
        type: Sequelize.BIGINT,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0,
            max: exports.maxCategoryFlags
        }
    }
};
exports.attributesVersion12 = {
    blockNotificationDelay: {
        type: Sequelize.BIGINT,
        allowNull: false,
        defaultValue: 0,
        validate: {
            min: 0
        }
    }
};
exports.attributes = Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2), exports.attributesVersion3), exports.attributesVersion4), exports.attributesVersion5), exports.attributesVersion6), exports.attributesVersion7), exports.attributesVersion8), exports.attributesVersion9), exports.attributesVersion10), exports.attributesVersion11), exports.attributesVersion12);
const createCategoryModel = (sequelize) => sequelize.define('Category', exports.attributes);
exports.createCategoryModel = createCategoryModel;
//# sourceMappingURL=category.js.map