"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAuthtokenModel = exports.attributes = exports.attributesVersion2 = exports.attributesVersion1 = void 0;
const Sequelize = require("sequelize");
const columns_1 = require("./columns");
exports.attributesVersion1 = {
    token: Object.assign(Object.assign({}, columns_1.authTokenColumn), { primaryKey: true }),
    mail: {
        type: Sequelize.STRING,
        allowNull: false,
        validate: {
            notEmpty: true
        }
    },
    createdAt: Object.assign({}, columns_1.timestampColumn)
};
exports.attributesVersion2 = {
    locale: {
        type: Sequelize.STRING,
        allowNull: false,
        defaultValue: 'en'
    }
};
exports.attributes = Object.assign(Object.assign({}, exports.attributesVersion1), exports.attributesVersion2);
const createAuthtokenModel = (sequelize) => sequelize.define('AuthToken', exports.attributes);
exports.createAuthtokenModel = createAuthtokenModel;
//# sourceMappingURL=authtoken.js.map