"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2023 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParentPasswordValidationException = exports.assertParentPasswordValid = exports.assertPlaintextParentPasswordValid = void 0;
const password_1 = require("../util/password");
const assertPlaintextParentPasswordValid = (password) => {
    (0, exports.assertParentPasswordValid)(Object.assign(Object.assign({}, password), { encrypted: false }));
};
exports.assertPlaintextParentPasswordValid = assertPlaintextParentPasswordValid;
const assertParentPasswordValid = (password) => {
    if (password.hash === '' || password.secondHash === '' || password.secondSalt === '') {
        throw new ParentPasswordValidationException('missing fields at parent password');
    }
    if (!(password_1.optionalPasswordRegex.test(password.hash) && password_1.optionalSaltRegex.test(password.secondSalt))) {
        throw new ParentPasswordValidationException('invalid parent password');
    }
    if (!password.encrypted && !password_1.optionalPasswordRegex.test(password.secondHash)) {
        throw new ParentPasswordValidationException('invalid parent password');
    }
};
exports.assertParentPasswordValid = assertParentPasswordValid;
class ParentPasswordValidationException extends Error {
}
exports.ParentPasswordValidationException = ParentPasswordValidationException;
//# sourceMappingURL=schema.js.map