"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadDevicePublicKeyAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const actionType = 'UploadDevicePublicKeyAction';
class UploadDevicePublicKeyAction extends basetypes_1.AppLogicAction {
    constructor({ key }) {
        super();
        if (key.length !== 32) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'key has wrong length'
            });
        }
        this.key = key;
    }
}
exports.UploadDevicePublicKeyAction = UploadDevicePublicKeyAction;
UploadDevicePublicKeyAction.parse = ({ key }) => (new UploadDevicePublicKeyAction({
    key: Buffer.from(key, 'base64')
}));
//# sourceMappingURL=uploaddevicepublickey.js.map