"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateParentNotificationFlagsAction = void 0;
const user_1 = require("../database/user");
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'UpdateParentNotificationFlagsAction';
class UpdateParentNotificationFlagsAction extends basetypes_1.ParentAction {
    constructor({ parentId, flags, set }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'parentId', value: parentId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'flags', value: flags });
        if (flags < 0 || flags > user_1.maxMailNotificationFlags) {
            (0, util_1.throwOutOfRange)({ actionType, field: 'flags', value: flags });
        }
        this.parentId = parentId;
        this.flags = flags;
        this.set = set;
    }
}
exports.UpdateParentNotificationFlagsAction = UpdateParentNotificationFlagsAction;
UpdateParentNotificationFlagsAction.parse = ({ parentId, flags, set }) => (new UpdateParentNotificationFlagsAction({ parentId, flags, set }));
//# sourceMappingURL=updateparentnotificationflags.js.map