"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateChildTaskAction = void 0;
const childtask_1 = require("../database/childtask");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'UpdateChildTaskAction';
class UpdateChildTaskAction extends basetypes_1.ParentAction {
    constructor({ isNew, taskId, categoryId, taskTitle, extraTimeDuration }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'taskId', value: taskId });
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'extraTimeDuration', value: extraTimeDuration });
        if (taskTitle === '' || taskTitle.length > childtask_1.maxTitleLength) {
            throw new exception_1.InvalidActionParameterException({ actionType, staticMessage: 'invalid title' });
        }
        if (extraTimeDuration <= 0 || extraTimeDuration > childtask_1.maxExtraTime) {
            (0, util_1.throwOutOfRange)({ actionType, field: 'extraTimeDuration', value: extraTimeDuration });
        }
        this.isNew = isNew;
        this.taskId = taskId;
        this.categoryId = categoryId;
        this.taskTitle = taskTitle;
        this.extraTimeDuration = extraTimeDuration;
    }
}
exports.UpdateChildTaskAction = UpdateChildTaskAction;
UpdateChildTaskAction.parse = ({ isNew, taskId, categoryId, taskTitle, extraTimeDuration }) => (new UpdateChildTaskAction({ isNew, taskId, categoryId, taskTitle, extraTimeDuration }));
//# sourceMappingURL=updatechildtaskaction.js.map