"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2021 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateCategoryFlagsAction = void 0;
const category_1 = require("../database/category");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'UpdateCategoryFlagsAction';
class UpdateCategoryFlagsAction extends basetypes_1.ParentAction {
    constructor({ categoryId, modifiedBits, newValues }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'modifiedBits', value: modifiedBits });
        (0, util_1.assertSafeInteger)({ actionType, field: 'newValues', value: newValues });
        if ((modifiedBits | category_1.maxCategoryFlags) !== category_1.maxCategoryFlags || (modifiedBits | newValues) !== modifiedBits) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'flags are out of the valid range',
                dynamicMessage: 'flags are out of the valid range: ' + modifiedBits + ', ' + newValues
            });
        }
        this.categoryId = categoryId;
        this.modifiedBits = modifiedBits;
        this.newValues = newValues;
    }
}
exports.UpdateCategoryFlagsAction = UpdateCategoryFlagsAction;
UpdateCategoryFlagsAction.parse = ({ categoryId, modified, values }) => (new UpdateCategoryFlagsAction({
    categoryId,
    modifiedBits: modified,
    newValues: values
}));
//# sourceMappingURL=updatecategoryflags.js.map