"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateCategoryBatteryLimitAction = void 0;
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'UpdateCategoryBatteryLimitAction';
class UpdateCategoryBatteryLimitAction extends basetypes_1.ParentAction {
    constructor({ categoryId, chargeLimit, mobileLimit }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        if (chargeLimit !== undefined) {
            (0, util_1.assertSafeInteger)({ actionType, field: 'chargeLimit', value: chargeLimit });
            if (chargeLimit < 0 || chargeLimit > 100) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'chargeLimit', value: chargeLimit });
            }
        }
        if (mobileLimit !== undefined) {
            (0, util_1.assertSafeInteger)({ actionType, field: 'mobileLimit', value: mobileLimit });
            if (mobileLimit < 0 || mobileLimit > 100) {
                (0, util_1.throwOutOfRange)({ actionType, field: 'mobileLimit', value: mobileLimit });
            }
        }
        this.categoryId = categoryId;
        this.chargeLimit = chargeLimit;
        this.mobileLimit = mobileLimit;
    }
}
exports.UpdateCategoryBatteryLimitAction = UpdateCategoryBatteryLimitAction;
UpdateCategoryBatteryLimitAction.parse = ({ categoryId, chargeLimit, mobileLimit }) => (new UpdateCategoryBatteryLimitAction({ categoryId, chargeLimit, mobileLimit }));
//# sourceMappingURL=updatecategorybatterylimit.js.map