"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateAppActivitiesAction = void 0;
const appactivity_1 = require("../model/appactivity");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'UpdateAppActivitiesAction';
class UpdateAppActivitiesAction extends basetypes_1.AppLogicAction {
    constructor({ removed, updatedOrAdded }) {
        super();
        (0, util_1.assertListWithoutDuplicates)({
            actionType,
            field: 'removed',
            list: removed.map((item) => item.packageName + ':' + item.activityName)
        });
        (0, util_1.assertListWithoutDuplicates)({
            actionType,
            field: 'updatedOrAdded',
            list: updatedOrAdded.map((item) => item.packageName + ':' + item.activityName)
        });
        if (removed.length === 0 && updatedOrAdded.length === 0) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'UpdateAppActivitiesAction is empty'
            });
        }
        this.removed = removed;
        this.updatedOrAdded = updatedOrAdded;
    }
}
exports.UpdateAppActivitiesAction = UpdateAppActivitiesAction;
UpdateAppActivitiesAction.parse = ({ removed, updatedOrAdded }) => {
    try {
        return new UpdateAppActivitiesAction({
            removed: removed.map((item) => appactivity_1.RemovedAppActivityItem.parse(item)),
            updatedOrAdded: updatedOrAdded.map((item) => appactivity_1.AppActivityItem.parse(item))
        });
    }
    catch (ex) {
        if (ex instanceof appactivity_1.IncompleteAppActivityItemException) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'invalid app activity item'
            });
        }
        else
            throw ex;
    }
};
//# sourceMappingURL=updateappactivities.js.map