"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetUserDisableLimitsUntilAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'SetUserDisableLimitsUntilAction';
class SetUserDisableLimitsUntilAction extends basetypes_1.ParentAction {
    constructor({ childId, timestamp }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'childId', value: childId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'timestamp', value: timestamp });
        if (timestamp < 0) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'timestamp for set user disabe limits until must be >= 0',
                dynamicMessage: 'timestamp for set user disabe limits until must be >= 0, but was ' + timestamp
            });
        }
        this.childId = childId;
        this.timestamp = timestamp;
    }
}
exports.SetUserDisableLimitsUntilAction = SetUserDisableLimitsUntilAction;
SetUserDisableLimitsUntilAction.parse = ({ childId, time }) => (new SetUserDisableLimitsUntilAction({
    childId,
    timestamp: time
}));
//# sourceMappingURL=setuserdisablelimitsuntil.js.map