"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetDeviceDefaultUserTimeoutAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'SetDeviceDefaultUserTimeoutAction';
class SetDeviceDefaultUserTimeoutAction extends basetypes_1.ParentAction {
    constructor({ deviceId, timeout }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'deviceId', value: deviceId });
        (0, util_1.assertSafeInteger)({ actionType, field: 'timeout', value: timeout });
        if (timeout < 0) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'timeout must be a non-negative integer',
                dynamicMessage: 'timeout must be a non-negative integer, was ' + timeout
            });
        }
        this.deviceId = deviceId;
        this.timeout = timeout;
    }
}
exports.SetDeviceDefaultUserTimeoutAction = SetDeviceDefaultUserTimeoutAction;
SetDeviceDefaultUserTimeoutAction.parse = ({ deviceId, timeout }) => (new SetDeviceDefaultUserTimeoutAction({ deviceId, timeout }));
//# sourceMappingURL=setdevicedefaultusertimeout.js.map