"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseChildAction = void 0;
const childchangepassword_1 = require("../childchangepassword");
const childsignin_1 = require("../childsignin");
const exception_1 = require("../meta/exception");
const parseChildAction = (serialized) => {
    if (serialized.type === 'CHILD_CHANGE_PASSWORD') {
        return childchangepassword_1.ChildChangePasswordAction.parse(serialized);
    }
    else if (serialized.type === 'CHILD_SIGN_IN') {
        return childsignin_1.ChildSignInAction.instance;
    }
    else {
        throw new exception_1.UnknownActionTypeException({ group: 'child' });
    }
};
exports.parseChildAction = parseChildAction;
//# sourceMappingURL=childaction.js.map