"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseAppLogicAction = void 0;
const addinstalledapps_1 = require("../addinstalledapps");
const addusedtime_1 = require("../addusedtime");
const addusedtime2_1 = require("../addusedtime2");
const finishkeyrequest_1 = require("../finishkeyrequest");
const forcesync_1 = require("../forcesync");
const replytokeyrequest_1 = require("../replytokeyrequest");
const marktaskpendingaction_1 = require("../marktaskpendingaction");
const exception_1 = require("../meta/exception");
const updateinstalledapps_1 = require("../updateinstalledapps");
const removeinstalledapps_1 = require("../removeinstalledapps");
const sendkeyrequest_1 = require("../sendkeyrequest");
const signoutatdevice_1 = require("../signoutatdevice");
const trieddisablingdeviceadmin_1 = require("../trieddisablingdeviceadmin");
const updateappactivities_1 = require("../updateappactivities");
const updatedevicestatus_1 = require("../updatedevicestatus");
const uploaddevicepublickey_1 = require("../uploaddevicepublickey");
const parseAppLogicAction = (serialized) => {
    if (serialized.type === 'ADD_USED_TIME') {
        return addusedtime_1.AddUsedTimeAction.parse(serialized);
    }
    else if (serialized.type === 'ADD_USED_TIME_V2') {
        return addusedtime2_1.AddUsedTimeActionVersion2.parse(serialized);
    }
    else if (serialized.type === 'ADD_INSTALLED_APPS') {
        return addinstalledapps_1.AddInstalledAppsAction.parse(serialized);
    }
    else if (serialized.type === 'FINISH_KEY_REQUEST') {
        return finishkeyrequest_1.FinishKeyRequestAction.parse(serialized);
    }
    else if (serialized.type === 'FORCE_SYNC') {
        return forcesync_1.ForceSyncAction.instance;
    }
    else if (serialized.type === 'REPLY_TO_KEY_REQUEST') {
        return replytokeyrequest_1.ReplyToKeyRequestAction.parse(serialized);
    }
    else if (serialized.type === 'MARK_TASK_PENDING') {
        return marktaskpendingaction_1.MarkTaskPendingAction.parse(serialized);
    }
    else if (serialized.type === 'UPDATE_INSTALLED_APPS') {
        return updateinstalledapps_1.UpdateInstalledAppsAction.parse(serialized);
    }
    else if (serialized.type === 'REMOVE_INSTALLED_APPS') {
        return removeinstalledapps_1.RemoveInstalledAppsAction.parse(serialized);
    }
    else if (serialized.type === 'SEND_KEY_REQUEST') {
        return sendkeyrequest_1.SendKeyRequestAction.parse(serialized);
    }
    else if (serialized.type === 'SIGN_OUT_AT_DEVICE') {
        return signoutatdevice_1.SignOutAtDeviceAction.instance;
    }
    else if (serialized.type === 'TRIED_DISABLING_DEVICE_ADMIN') {
        return new trieddisablingdeviceadmin_1.TriedDisablingDeviceAdminAction();
    }
    else if (serialized.type === 'UPDATE_APP_ACTIVITIES') {
        return updateappactivities_1.UpdateAppActivitiesAction.parse(serialized);
    }
    else if (serialized.type === 'UPDATE_DEVICE_STATUS') {
        return updatedevicestatus_1.UpdateDeviceStatusAction.parse(serialized);
    }
    else if (serialized.type === 'UPLOAD_DEVICE_PUBLIC_KEY') {
        return uploaddevicepublickey_1.UploadDevicePublicKeyAction.parse(serialized);
    }
    else {
        throw new exception_1.UnknownActionTypeException({ group: 'app logic' });
    }
};
exports.parseAppLogicAction = parseAppLogicAction;
//# sourceMappingURL=applogicaction.js.map