"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReplyToKeyRequestAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'ReplyToKeyRequestAction';
class ReplyToKeyRequestAction extends basetypes_1.AppLogicAction {
    constructor({ requestServerSequenceNumber, tempKey, encryptedKey, signature }) {
        super();
        (0, util_1.assertSafeInteger)({ value: requestServerSequenceNumber, field: 'requestServerSequenceNumber', actionType });
        if (tempKey.length !== 32 || encryptedKey.length !== 16 || signature.length !== 64) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'key/signature has wrong length'
            });
        }
        this.requestServerSequenceNumber = requestServerSequenceNumber;
        this.tempKey = tempKey;
        this.encryptedKey = encryptedKey;
        this.signature = signature;
    }
}
exports.ReplyToKeyRequestAction = ReplyToKeyRequestAction;
ReplyToKeyRequestAction.parse = ({ rsn, tempKey, encryptedKey, signature }) => (new ReplyToKeyRequestAction({
    requestServerSequenceNumber: rsn,
    tempKey: Buffer.from(tempKey, 'base64'),
    encryptedKey: Buffer.from(encryptedKey, 'base64'),
    signature: Buffer.from(signature, 'base64')
}));
//# sourceMappingURL=replytokeyrequest.js.map