"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RenameChildAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'RenameChildAction';
class RenameChildAction extends basetypes_1.ParentAction {
    constructor({ childId, newName }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'childId', value: childId });
        if (newName === '') {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'new name must not be empty'
            });
        }
        this.childId = childId;
        this.newName = newName;
    }
}
exports.RenameChildAction = RenameChildAction;
RenameChildAction.parse = ({ childId, newName }) => (new RenameChildAction({ childId, newName }));
//# sourceMappingURL=renamechild.js.map