"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateTimeLimitRuleAction = void 0;
const timelimitrule_1 = require("../model/timelimitrule");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const actionType = 'CreateTimeLimitRuleAction';
class CreateTimeLimitRuleAction extends basetypes_1.ParentAction {
    constructor({ rule }) {
        super();
        this.rule = rule;
    }
}
exports.CreateTimeLimitRuleAction = CreateTimeLimitRuleAction;
CreateTimeLimitRuleAction.parse = ({ rule }) => {
    try {
        return new CreateTimeLimitRuleAction({
            rule: timelimitrule_1.TimelimitRule.parse(rule)
        });
    }
    catch (ex) {
        if (ex instanceof timelimitrule_1.ParseTimeLimitRuleException) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'invalid time limit rule',
                dynamicMessage: 'invalid time limit rule: ' + ex.toString()
            });
        }
        else
            throw ex;
    }
};
//# sourceMappingURL=createtimelimitrule.js.map