"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddUserAction = void 0;
const schema_1 = require("../api/schema");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'AddUserAction';
class AddUserAction extends basetypes_1.ParentAction {
    constructor({ userId, name, userType, password, timeZone }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'userId', value: userId });
        this.userId = userId;
        this.name = name;
        this.userType = userType;
        this.password = password;
        this.timeZone = timeZone;
        if (userType === 'parent') {
            if (!password) {
                throw new exception_1.InvalidActionParameterException({
                    actionType,
                    staticMessage: 'parent users must have got an password'
                });
            }
        }
        if (password) {
            try {
                (0, schema_1.assertParentPasswordValid)(password);
            }
            catch (ex) {
                if (ex instanceof schema_1.ParentPasswordValidationException) {
                    throw new exception_1.InvalidActionParameterException({
                        actionType,
                        staticMessage: 'invalid password data'
                    });
                }
                else
                    throw ex;
            }
        }
    }
}
exports.AddUserAction = AddUserAction;
AddUserAction.parse = ({ name, userId, userType, password, timeZone }) => (new AddUserAction({
    name,
    userId,
    userType,
    password,
    timeZone
}));
//# sourceMappingURL=adduser.js.map