"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddUsedTimeAction = void 0;
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'AddUsedTimeAction';
class AddUsedTimeAction extends basetypes_1.AppLogicAction {
    constructor({ categoryId, dayOfEpoch, timeToAdd, extraTimeToSubtract }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        if (dayOfEpoch < 0 || (!Number.isSafeInteger(dayOfEpoch))) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'invalid dayOfEpoch',
                dynamicMessage: 'invalid dayOfEpoch: ' + dayOfEpoch
            });
        }
        if (timeToAdd < 0 || (!Number.isSafeInteger(timeToAdd))) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'illegal timeToAdd',
                dynamicMessage: 'illegal timeToAdd: ' + timeToAdd
            });
        }
        if (extraTimeToSubtract < 0 || (!Number.isSafeInteger(extraTimeToSubtract))) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'illegal extra time to subtract',
                dynamicMessage: 'illegal extra time to subtract: ' + extraTimeToSubtract
            });
        }
        this.categoryId = categoryId;
        this.dayOfEpoch = dayOfEpoch;
        this.timeToAdd = timeToAdd;
        this.extraTimeToSubtract = extraTimeToSubtract;
    }
}
exports.AddUsedTimeAction = AddUsedTimeAction;
AddUsedTimeAction.parse = ({ categoryId, day, timeToAdd, extraTimeToSubtract }) => (new AddUsedTimeAction({
    categoryId,
    dayOfEpoch: day,
    timeToAdd,
    extraTimeToSubtract
}));
//# sourceMappingURL=addusedtime.js.map