"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddInstalledAppsAction = void 0;
const installedapp_1 = require("../model/installedapp");
const basetypes_1 = require("./basetypes");
const util_1 = require("./meta/util");
const actionType = 'AddInstalledAppsAction';
class AddInstalledAppsAction extends basetypes_1.AppLogicAction {
    constructor({ apps }) {
        super();
        (0, util_1.assertNonEmptyListWithoutDuplicates)({ actionType, field: 'apps', list: apps.map((app) => app.packageName) });
        this.apps = apps;
    }
}
exports.AddInstalledAppsAction = AddInstalledAppsAction;
AddInstalledAppsAction.parse = ({ apps }) => (new AddInstalledAppsAction({
    apps: apps.map((app) => installedapp_1.InstalledApp.parse(app))
}));
//# sourceMappingURL=addinstalledapps.js.map