"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AddCategoryNetworkIdAction = void 0;
const categorynetworkid_1 = require("../database/categorynetworkid");
const basetypes_1 = require("./basetypes");
const exception_1 = require("./meta/exception");
const util_1 = require("./meta/util");
const actionType = 'AddCategoryNetworkIdAction';
class AddCategoryNetworkIdAction extends basetypes_1.ParentAction {
    constructor({ categoryId, itemId, hashedNetworkId }) {
        super();
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'categoryId', value: categoryId });
        (0, util_1.assertIdWithinFamily)({ actionType, field: 'itemId', value: itemId });
        (0, util_1.assertHexString)({ actionType, field: 'hashedNetworkId', value: hashedNetworkId });
        if (hashedNetworkId.length !== categorynetworkid_1.anonymizedNetworkIdLength) {
            throw new exception_1.InvalidActionParameterException({
                actionType,
                staticMessage: 'wrong network id length'
            });
        }
        this.categoryId = categoryId;
        this.itemId = itemId;
        this.hashedNetworkId = hashedNetworkId;
    }
}
exports.AddCategoryNetworkIdAction = AddCategoryNetworkIdAction;
AddCategoryNetworkIdAction.parse = ({ categoryId, itemId, hashedNetworkId }) => (new AddCategoryNetworkIdAction({
    categoryId,
    itemId,
    hashedNetworkId
}));
//# sourceMappingURL=addcategorynetworkid.js.map