"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.initWorkers = initWorkers;
const delete_deprecated_purchases_1 = require("./delete-deprecated-purchases");
const delete_old_families_1 = require("./delete-old-families");
const delete_old_tokens_1 = require("./delete-old-tokens");
const delete_old_used_times_1 = require("./delete-old-used-times");
function initWorkers({ database, websocket }) {
    (0, delete_deprecated_purchases_1.initDeleteDeprecatedPurchasesWorker)({ database, websocket });
    (0, delete_old_families_1.initDeleteOldFamiliesWorker)({ database });
    (0, delete_old_tokens_1.initDeleteOldTokensWorker)({ database });
    (0, delete_old_used_times_1.initDeleteOldUsedTimesWorker)({ database });
}
//# sourceMappingURL=index.js.map