"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.areWordSequencesEqual = exports.randomWords = void 0;
const crypto_1 = require("crypto");
const fs_1 = require("fs");
const lodash_1 = require("lodash");
const path_1 = require("path");
const wordlist = (0, fs_1.readFileSync)((0, path_1.resolve)(__dirname, '../../other/wordlist/de.txt'))
    .toString()
    .split('\n')
    .filter((item) => item.trim().length > 0);
const randomWord = () => wordlist[(0, crypto_1.randomInt)(wordlist.length)];
const randomWords = (numberOfWords) => ((0, lodash_1.range)(numberOfWords)
    .map(() => randomWord())
    .join(' '));
exports.randomWords = randomWords;
const preprocessStringForComparing = (input) => (input
    .replace(/ |\*/g, '')
    .toLowerCase());
const areWordSequencesEqual = (a, b) => (preprocessStringForComparing(a) === preprocessStringForComparing(b));
exports.areWordSequencesEqual = areWordSequencesEqual;
//# sourceMappingURL=random-words.js.map